*****************************************************************************
**                                                                         **
** Samplesaver: RIFF-8SVX                                                  **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
*****************************************************************************

*-----------------------------------------------------------------------------*
*			Samplesaver for RIFF 8SVX-Samples		      *
*-----------------------------------------------------------------------------*

			incdir	include:
			include	exec/exec_lib.i
			include	dos/dos.i
			include	dos/dos_lib.i
			include	misc/eagleplayersamplesaver.i
			include	misc/BuggsMacros.i

ID_RIFF	equ	`RIFF`
ID_WAVE	equ	`WAVE`
ID_fmt	equ	`fmt `
ID_fact	equ	`fact`
ID_cue	equ	`cue `
ID_data	equ	`data`

WAVE_FORMAT_PCM		equ	$001	;M$ PCM
IBM_FORMAT_MULAW	equ	$101	;IBM mu-law format
IBM_FORMAT_ALAW		equ	$102	;IBM a-law format
IBM_FORMAT_ADPCM	equ	$103	;IBM AVC Adaptive Differential Pulse Code Modulation format

 structure	WAVE_fmt,0
	ulong	fmt_ID
	ulong	fmt_Size
	word	fmt_wFormatTag			;Format category
	word	fmt_wChannels			;Number of channels
	ulong	fmt_dwSamplesPerSec		;Sampling rate
	ulong	fmt_dwAvgBytesPerSec		;For buffer
	uword	fmt_wBlockAlign			;Data block size (Bytesperframe)
	Label	fmt_Sizeof
	uword	PCMfmt_wBitsPerSample		;Sample size

iword	macro
	ror.w	#8,\1
	endm

ilword	macro
	ror	#8,\1
	swap	\1
	ror	#8,\1
	endm

	SAMPLESAVERHEADER	TAGS8

	dc.b	"RIFF WAVE 8Bit /16 Bit - Mono Samplesaver V1.00",10
	dc.b	"done by Buggs/DFT 09.04.97",0
	even

AllMore:	dc.l	SS_Version,1<<16!0
		dc.l	SS_Creator,Creator
		dc.l	SS_Flags,SSF_FrequencyVariable
		dc.l	0

Tags8:		dc.l	Tag_More,AllMore
		dc.l	SS_Formatname,Formatname8
		dc.l	SS_RAWFlags,USIB_8Bit!USIB_Unsigned
		dc.l	SS_DefFreqPtr,FreqPtr8
		dc.l	SS_DescriptionLNr,43
		dc.l	SS_SaveSample,SaveSample8

		dc.l	SS_NextSampleSaver,Tags16
		dc.l	0

Tags16:		dc.l	Tag_More,AllMore
		dc.l	SS_Formatname,Formatname16
		dc.l	SS_RAWFlags,USIB_16Bit!USIB_Intel
		dc.l	SS_DefFreqPtr,FreqPtr16
		dc.l	SS_SaveSample,SaveSample16

		dc.l	0

FreqPtr8:	dc.l	22000
FreqPtr16:	dc.l	22000

Creator:	dc.b	"Mico$oft RIFF Samples, saver by DEFECT",0

Formatname8:	dc.b	"WAVE PCM 8Bit",0
Formatname16:	dc.b	"WAVE PCM 16Bit",0

dos		dc.b	`dos.library`,0
Comment:	dc.b	`written by Eagleplayer Samplesaver  Defect Softworks`,0
		even

*-----------------------------------------------------------------------------*
* Input: a0=Adr der EP_SampleTabelle
*	 a1=Pfad
*	 a2=Jump to Saveroutine
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
SaveSample16:	moveq	#1,d5
		move.l	FreqPtr16(pc),d3
		bra.s	SaveSample

SaveSample8:	moveq	#0,d5
		move.l	FreqPtr8(pc),d3

SaveSample:	move.l	a1,a2

		moveq	#EPR_ErrorInArguments,d7
		move.l	a0,a4
		moveq	#0,d6
		move.l	EPS_Adr(a4),d0
		beq.w	.Return
		move.l	d0,a3

		move.w	EPS_Type(a4),d0		;nur RAW als Input
		bne.w	.Return			;

		move.l	EPS_Length(a4),d4
		beq.w	.Return

		ilword	d3			;in Intel Format
		move.l	d3,PlayRate		;sichern
		ilword	d3			;zurck nach Motorola

		ilword	d4
		move.l	d4,RawSize
		ilword	d4
		move.l	d4,d0
		add.l	#HeaderEnd-RIFFHeader-8,d0
		ilword	d0
		move.l	d0,OverAllSize

		moveq	#1,d0
		tst.b	d5
		beq	.Sample8
		add.l	d3,d3			;Samplerate * 2 Bytes pro Eintrag
		moveq	#2,d0
.Sample8
		ilword	d3
		move.l	d3,BytesPerSec
		iword	d0
		move	d0,BytesPerFrame
		lsl	#3,d0
		move	d0,BitsperSample

	*------------------- File ffnen und abspeichern ----------------*
		move.l	4.w,a6
		lea	dos(pc),a1
		moveq	#33,d0
		jsr	_LVOopenlibrary(A6)	;Open DOS
		tst.l	d0
		beq	.error
		move.l	d0,a6

		move.l	a2,d1
		move.l	#1006,d2		;MODE_NEWFILE
		jsr	_LVOopen(A6)
		move.l	d0,d6
		beq.s	.nolock

		move.l	d0,d1				;Handle
		lea	RIFFHeader(pc),a1
		move.l	a1,d2				;Adr
		move.l	#HeaderEnd-RIFFHeader,d3	;len
		jsr	_LVOwrite(a6)
		tst.l	d0
		bmi.s	.fail

		move.l	d6,d1
		move.l	a3,d2
		move.l	d4,d3
		jsr	_LVOWrite(a6)
		tst.l	d0
		bmi.s	.fail

		move.l	d6,d1
		jsr	_LVOclose(a6)

		move.l	a2,d1
		move.l	#Comment,d2
		jsr	_LVOSetComment(A6)

		bsr.s	.nolock

		moveq	#0,d7
.Return:	move.l	d7,d0
		tst.l	d0
		rts
.fail
		move.l	d6,d1
		jsr	_LVOclose(a6)
.nolock
		move.l	a6,a1
		move.l	4.w,a6
		jsr	_LVOcloselibrary(A6)

.error		moveq	#EPR_SaveError,d0
		rts

RIFFHeader:
		dc.l	ID_RIFF
OverallSize:	dc.l	0
SampleType:	dc.l	ID_WAVE
		dc.l	ID_fmt
		dc.b	$10,0,0,0	;10.l in Intel-Manier
		dc.b	01,00		;WAVE_FORMAT_PCM in Intel-Manier
		dc.b	01,00		;Channels (1) in Intel-Manier
PlayRate:	dc.l	0		;Samplerate, wird vom Prog gesetzt
BytesPerSec:	dc.l	0		;verwendete Bytes pro Sekunde (Playrate oder PR*2 bei Mono)
BytesPerFrame:	dc.w	0		;Bytes pro Sampleeinheit (1 oder 2 fr Mono-PCM) in Intel
BitsPerSample:	dc.w	0		;Bittiefe des Samples (8 oder 16) in Intel

		dc.l	ID_data
RawSize		dc.l	0

HeaderEnd:
